<?php

use App\Http\Controllers\V1\{CategoryController,
    CityController,
    FooterTitleController,
    FooterTitleDetailController,
    LabelController,
    SettingController,
    SliderController,
    StateController,
    TagController,
    CountryController};

//Categories
Route::prefix('categories')->group(function () {
    Route::get('/', [CategoryController::class, 'index']);
    Route::get('/paginated', [CategoryController::class, 'indexpaginated']);
    Route::get('/{id}', [CategoryController::class, 'getById']);
    Route::post('create', [CategoryController::class, 'store']);
    Route::post('update/{id}', [CategoryController::class, 'update']);
    Route::put('change-status/{id}', [CategoryController::class, 'changeStatus']);
    
    Route::delete('/{id}', [CategoryController::class, 'destroy']);

});

//Countries
    Route::prefix('countries')->group(function () {
        
        Route::get('/', [CountryController::class, 'index']); 
        Route::get('/paginated', [CountryController::class, 'indexpaginated']); 
        Route::post('/create', [CountryController::class, 'store']);
        Route::get('/{id}', [CountryController::class, 'getById']);
        Route::post('/update/{id}', [CountryController::class, 'update']);
        Route::put('/change-status/{id}', [CountryController::class, 'changeStatus']);
        Route::delete('/{id}', [CountryController::class, 'destroy']);

    });

//States
Route::prefix('states')->group(function () {
    Route::get('/', [StateController::class, 'index']);
    Route::get('/paginated', [StateController::class, 'indexpaginated']);
    Route::get('/{id}', [StateController::class, 'getById']);
    Route::post('create', [StateController::class, 'store']);
    Route::post('update/{id}', [StateController::class, 'update']);
    Route::put('change-status/{id}', [StateController::class, 'changeStatus']);
    Route::delete('/{id}', [StateController::class, 'destroy']);

});

//Cities
Route::prefix('cities')->group(function () {
    Route::get('/', [CityController::class, 'index']);
    Route::get('/paginated', [CityController::class, 'indexpaginated']);
    Route::get('/{id}', [CityController::class, 'getById']);
    Route::post('create', [CityController::class, 'store']);
    Route::post('update/{id}', [CityController::class, 'update']);
    Route::put('change-status/{id}', [CityController::class, 'changeStatus']);
    Route::delete('/{id}', [CityController::class, 'destroy']);
});

//Tags
Route::prefix('tags')->group(function () {
    Route::get('/', [TagController::class, 'index']);
    Route::get('/{id}', [TagController::class, 'getById']);
    Route::post('create', [TagController::class, 'store']);
    Route::post('update/{id}', [TagController::class, 'update']);
    Route::put('change-status/{id}', [TagController::class, 'changeStatus']);
});

//Sliders
Route::prefix('sliders')->group(function () {
    Route::get('/', [SliderController::class, 'index']);
    Route::get('/{id}', [SliderController::class, 'getById']);
    Route::post('create', [SliderController::class, 'store']);
    Route::post('update/{id}', [SliderController::class, 'update']);
    Route::put('change-status/{id}', [SliderController::class, 'changeStatus']);
    Route::delete('/{id}', [SliderController::class, 'destroy']);

});

////Labels
Route::prefix('labels')->group(function () {
    Route::get('/', [LabelController::class, 'index']);
    Route::get('/{id}', [LabelController::class, 'getById']);
    Route::post('create', [LabelController::class, 'store']);
    Route::post('update/{id}', [LabelController::class, 'update']);
    Route::put('change-status/{id}', [LabelController::class, 'changeStatus']);
});

//Settings
Route::prefix('settings')->group(function () {
    Route::get('/', [SettingController::class, 'index']);
    Route::get('/{id}', [SettingController::class, 'getById']);
    Route::post('update/{id}', [SettingController::class, 'update']);
});

//Footer Title
Route::prefix('footer-titles')->group(function () {
    Route::get('/', [FooterTitleController::class, 'index']);
    Route::get('/notpaginated', [FooterTitleController::class, 'indexnotpaginated']);
    Route::get('/{id}', [FooterTitleController::class, 'getById']);
    Route::post('create', [FooterTitleController::class, 'store']);
    Route::post('update/{id}', [FooterTitleController::class, 'update']);
    Route::put('change-status/{id}', [FooterTitleController::class, 'changeStatus']);
    Route::delete('/{id}', [FooterTitleController::class, 'destroy']);

});

//Footer Title Detail
Route::prefix('footer-title-details')->group(function () {
    Route::get('/', [FooterTitleDetailController::class, 'index']);
        Route::get('/notpaginated', [FooterTitleDetailController::class, 'indexnotpaginated']);
    Route::get('/{id}', [FooterTitleDetailController::class, 'getById']);
    Route::post('create', [FooterTitleDetailController::class, 'store']);
    Route::post('update/{id}', [FooterTitleDetailController::class, 'update']);
    Route::put('change-status/{id}', [FooterTitleDetailController::class, 'changeStatus']);
     Route::delete('/{id}', [FooterTitleDetailController::class, 'destroy']);

});

//Test
Route::prefix('test-endpoints')->group(function () {
    Route::get('/', function (){
        return api_response(message: __('general.success_request'));
    });
});
