<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\V1\BlogController;

Route::get('withauth/', [BlogController::class, 'index']);
Route::get('withauth/{id}', [BlogController::class, 'getById']);
Route::post('store', [BlogController::class, 'storeBlog']);
Route::post('update/{id}', [BlogController::class, 'updateBlog']);
Route::delete('image/{id}', [BlogController::class, 'deleteImage']);
Route::post('upload-image', [BlogController::class, 'uploadImage']);
Route::post('upload-images', [BlogController::class, 'uploadImages']);
Route::delete('{id}', [BlogController::class, 'delete']);
