<?php

namespace Database\Seeders;

use App\Enums\StatusEnum;
use App\Models\InternalUser;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        $user = InternalUser::query()->firstOrCreate(
            [
                'phone_number' => '01029804915',
            ],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('sorouh@admin1'),
                'status' => StatusEnum::ACTIVE->value,
                'is_admin' => StatusEnum::ACTIVE->value,
            ]
        );

        $this->call([
            PermissionsTableSeeder::class,
            SettingsTableSeeder::class,
        ]);

        $role = Role::firstOrCreate(['name' => 'super-admin']);

        if (! $user->hasRole('super-admin')) {
            $user->assignRole('super-admin');
        }
    }
}
