<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('property_requirements', function (Blueprint $table) {
            $table->id();
            $table->enum('user_type', ['seeker', 'landlord', 'broker']);
            $table->enum('price_range', ['more_than_2m', '1m_to_2m', '500k_to_1m', 'less_than_500k']);
            $table->unsignedBigInteger('city_id');
            $table->unsignedBigInteger('category_id');
            $table->string('full_name');
            $table->boolean('terms_accepted');
            $table->tinyInteger('status')->default(0);
            $table->timestamps();

            $table->foreign('city_id')->references('id')->on('cities')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('property_requirements');
    }
};
