<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->decimal('price', 15, 2)->nullable()->after('name_ar')->comment('سعر العقار');
            $table->string('price_currency', 10)->default('SAR')->after('price')->comment('SAR, USD, EUR');
            
            $table->decimal('total_area', 10, 2)->nullable()->after('price_currency')->comment('المساحة الإجمالية م²');
            $table->decimal('land_area', 10, 2)->nullable()->after('total_area')->comment('مساحة الأرض م²');
            $table->decimal('built_area', 10, 2)->nullable()->after('land_area')->comment('مساحة البناء م²');
            
            $table->integer('total_floors')->nullable()->after('built_area')->comment('عدد الطوابق');
            $table->integer('total_units')->nullable()->after('total_floors')->comment('عدد الوحدات');
            
            $table->date('handover_date')->nullable()->after('total_units')->comment('تاريخ التسليم');
            
            $table->tinyInteger('offer_type')->default(1)->after('handover_date')->comment('1=بيع, 2=إيجار, 3=استثمار');
            $table->tinyInteger('condition')->default(1)->after('offer_type')->comment('1=جديد, 2=مستعمل, 3=تحت الإنشاء');
            
            $table->boolean('has_pool')->default(false)->after('condition');
            $table->boolean('has_gym')->default(false)->after('has_pool');
            $table->boolean('has_parking')->default(false)->after('has_gym');
            $table->boolean('furnished')->default(false)->after('has_parking')->comment('مفروش');
            
            $table->decimal('down_payment', 15, 2)->nullable()->after('furnished');
            $table->integer('installments_count')->nullable()->after('down_payment');
            $table->decimal('installment_amount', 15, 2)->nullable()->after('installments_count');
        });
    }

    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropColumn([
                'price', 'price_currency', 'total_area', 'land_area', 'built_area',
                'total_floors', 'total_units', 'handover_date', 'offer_type', 
                'condition', 'has_pool', 'has_gym', 'has_parking', 'furnished',
                'down_payment', 'installments_count', 'installment_amount'
            ]);
        });
    }
};
