<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('footer_title_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('footer_title_id');
            $table->string('title_en');
            $table->string('title_ar');
            $table->tinyInteger('status')->default(0)->comment('0 => inactive | 1 => active')->index();
            $table->tinyInteger('redirect_to')->default(1)->comment('1 => internal | 2 => external');
            $table->text('link')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('footer_title_details');
    }
};
