<?php

namespace App\Repositories\V1\Users;

use App\Models\User;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface UserRepositoryInterface
{
    public function first(array $conditions): ?User;

    public function update(int $userId, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function getById(int $id): User;
}
