<?php

namespace App\Repositories\V1\SubCategories;

use App\Models\SubCategory;
use App\Dto\V1\SubCategoryDto;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Pagination\LengthAwarePaginator;

interface SubCategoryRepositoryInterface
{
    public function index(Utility $utility, int $limit): LengthAwarePaginator;
    public function find(int $id): SubCategory;
    public function store(SubCategoryDto $dto): SubCategory;
    public function update(SubCategoryDto $dto, int $id): SubCategory;
    public function delete(int $id): void;
    public function getByCategoryId(Utility $utility, int $categoryId, int $limit);
}
