<?php

namespace App\Repositories\V1\SubCategories;

use App\Models\SubCategory;
use App\Dto\V1\SubCategoryDto;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Pagination\LengthAwarePaginator;

class SubCategoryRepository implements SubCategoryRepositoryInterface
{
   

     public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(SubCategory::query())
            ->orderByDesc('id')->paginate($limit);
    }

    public function find(int $id): SubCategory
    {
        return SubCategory::findOrFail($id);
    }

    public function store(SubCategoryDto $dto): SubCategory
    {
        return SubCategory::create([
            'name_en'        => $dto->nameEn,
            'name_ar'        => $dto->nameAr,
            'slug'        => $dto->slug,
            'slug_ar'        => $dto->slugAr,
            'category_id' => $dto->categoryId,
        ]);
    }

    public function update(SubCategoryDto $dto, int $id): SubCategory
    {
        $subCategory = $this->find($id);

        $subCategory->update([
            'name_en'        => $dto->nameEn,
            'name_ar'        => $dto->nameAr,
            'slug'        => $dto->slug,
            'slug_ar'        => $dto->slugAr,
            'category_id' => $dto->categoryId,
        ]);

        return $subCategory;
    }

    public function delete(int $id): void
    {
        $this->find($id)->delete(); // soft delete
    }
    
    public function getByCategoryId(Utility $utility, int $categoryId, int $limit)
    {
        return $utility->applyOnBuilder(
                SubCategory::query()->where('category_id', $categoryId)
            )
            ->orderByDesc('id')
            ->paginate($limit);
    }
}
