<?php

namespace App\Repositories\V1\States;

use App\Models\State;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Pagination\LengthAwarePaginator;


interface StateRepositoryInterface
{
    public function first(array $conditions): ?State;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility): Collection;
    
    public function indexPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator;

    public function create(array $data): State;

    public function getById(int $id): State;
}
