<?php

namespace App\Repositories\V1\Sliders;

use App\Models\Slider;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface SliderRepositoryInterface
{
    public function first(array $conditions): ?Slider;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): Slider;

    public function getById(int $id): Slider;
}
