<?php

namespace App\Repositories\V1\Settings;

use App\Models\Setting;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface SettingRepositoryInterface
{
    public function first(array $conditions): ?Setting;

    public function updateOrCreate(array $where, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function getById(int $id): Setting;
    
    public function all(Utility $utility): \Illuminate\Support\Collection;
}
