<?php

namespace App\Repositories\V1\Roles;

use App\Models\Permission;
use App\Models\PermissionGroup;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;
use Spatie\Permission\Models\Role;

class MysqlPermissionRepository implements PermissionRepositoryInterface
{
    public function index(): Collection
    {
        return PermissionGroup::query()->with('permissions')->get();
    }

    public function getRoles(Utility $utility): Collection
    {
        return $utility->applyOnBuilder(Role::query())
            ->with('permissions')->orderByDesc('id')->get();
    }
    
    public function getRolesPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator
    {
        return $utility
            ->applyOnBuilder(Role::query())
            ->with('permissions')
            ->orderByDesc('id')
            ->paginate($perPage);
    }


    public function create(array $data): Role
    {
        return Role::query()->create($data);
    }

    public function getPermissionsByIds(array $ids): Collection
    {
        return Permission::query()->whereIn('id', $ids)->get();
    }

    public function update(int $id, array $data): bool
    {
        return Role::query()->where('id', '=', $id)->update($data);
    }

    public function getById(int $id): Role
    {
        return Role::query()->findOrFail($id);
    }

    public function getRolesByIds(array $ids): Collection
    {
        return Role::query()->whereIn('id', $ids)->get();
    }
}
