<?php

namespace App\Repositories\V1\Projects;

use App\Models\Project;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;

interface ProjectRepositoryInterface
{
    public function store(array $data): Project;

    public function first(int $id): ?Project;

    public function update(int $id, array $data): bool;

    public function findById(int $id): ?Project;

    public function getProfessionalProjects(Utility $utility, int $userId): Collection;

    public function getProjects(Utility $utility): LengthAwarePaginator;

    public function getProjectsWithoutPagination(Utility $utility): Collection;

    public function getProjectWithDetails(int $id, array $conditions = []):
        ?Project;

    public function getSimilarProjectByCategoryId(int $projectId, int $categoryId, int $limit): LengthAwarePaginator;

    public function findOrFail(int $id, array $conditions = []): Project;
}
