<?php

namespace App\Repositories\V1\Projects;

use App\Models\ProjectComment;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface ProjectCommentRepositoryInterface
{
    public function create(array $data): ProjectComment;

    public function findOrFailMainComment(int $id): ProjectComment;

    public function getTopLevelComments(int $projectId, int $limit): LengthAwarePaginator;
}
