<?php

namespace App\Repositories\V1\Labels;

use App\Models\Label;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlLabelRepository implements LabelRepositoryInterface
{
    public function first(array $conditions): ?Label
    {
        return Label::query()->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return Label::where('id', $id)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(Label::query())
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): Label
    {
        return Label::query()->create($data);
    }

    public function getById(int $id): Label
    {
        return Label::query()->findOrFail($id);
    }
}
