<?php

namespace App\Repositories\V1\Labels;

use App\Models\Label;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface LabelRepositoryInterface
{
    public function first(array $conditions): ?Label;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): Label;

    public function getById(int $id): Label;
}
