<?php

namespace App\Repositories\V1\Footers;

use App\Models\FooterTitle;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlFooterTitleRepository implements FooterTitleRepositoryInterface
{
    public function first(array $conditions): ?FooterTitle
    {
        return FooterTitle::query()->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return FooterTitle::where('id', $id)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(FooterTitle::query())
            ->with('details')
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): FooterTitle
    {
        return FooterTitle::query()->create($data);
    }

    public function getById(int $id): FooterTitle
    {
        return FooterTitle::query()->findOrFail($id);
    }
    
    public function indexAll(Utility $utility)
    {
        return $utility->applyOnBuilder(FooterTitle::query())
            ->with('details')
            ->orderByDesc('id')
            ->get(); 
    }

}
