<?php

namespace App\Repositories\V1\Footers;

use App\Models\FooterTitle;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface FooterTitleRepositoryInterface
{
    public function first(array $conditions): ?FooterTitle;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): FooterTitle;

    public function getById(int $id): FooterTitle;
    
    public function indexAll(Utility $utility);

}
