<?php

namespace App\Repositories\V1\Contacts;

use App\Models\Contact;
use Illuminate\Pagination\LengthAwarePaginator;

interface ContactRepositoryInterface
{
    public function create(array $data): Contact;

    public function index(int $limit): LengthAwarePaginator;

    public function getById(int $id): Contact;

    public function update(int $id, array $data): bool;

    public function delete(int $id): void;
}
