<?php

namespace App\Repositories\V1\Cities;

use App\Models\City;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Database\Eloquent\Collection;

class MysqlCityRepository implements CityRepositoryInterface
{
    public function first(array $conditions): ?City
    {
        return City::query()->with('state')->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return City::where('id', $id)->update($data);
    }

    public function index(Utility $utility): Collection
    {
        return $utility->applyOnBuilder(City::query())
            ->with('state')
            ->orderByDesc('id')->get();
    }
    
    public function indexPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator
    {
        return $utility
            ->applyOnBuilder(City::query())
            ->orderByDesc('id')
            ->paginate($perPage);
    }



    public function create(array $data): City
    {
        return City::query()->create($data);
    }

    public function getById(int $id): City
    {
        return City::query()->findOrFail($id);
    }
}
