<?php

namespace App\Repositories\V1\Categories;

use App\Models\Category;
use App\Models\CategoryProfessional;
use App\Models\User;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlCategoryRepository implements CategoryRepositoryInterface
{
    public function first(array $conditions): ?Category
    {
        return Category::query()->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return Category::where('id', $id)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(Category::query())
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): Category
    {
        return Category::query()->create($data);
    }

    public function getById(int $id): Category
    {
        return Category::query()->findOrFail($id);
    }

    public function getCategoryProfessionalsByCategoryId(int $id): Collection
    {
        return User::query()
            ->join('category_professionals', 'users.id', '=', 'category_professionals.user_id')
            ->where('category_professionals.category_id', $id)
            ->orderByRaw('ISNULL(category_professionals.sort), category_professionals.sort ASC')
            ->select('users.*', 'category_professionals.status as category_status', 'category_professionals.sort as category_sort', 'category_professionals.id as category_id')
            ->get();

    }

    public function updateCategoryProfessionals(int $id, array $data): bool
    {
        return CategoryProfessional::where('id', $id)->update($data);
    }

    public function createCategoryProfessionals(array $data): CategoryProfessional
    {
        return CategoryProfessional::query()->create($data);
    }
}
