<?php

namespace App\Repositories\V1\Blogs;

use App\Models\Blog;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;


class MysqlBlogRepository implements BlogRepositoryInterface
{
    public function index(int $limit): LengthAwarePaginator
    {
        return Blog::query()
            ->orderByDesc('id')
            ->paginate($limit);
    }

    public function getById(int $id): Blog
    {
        return Blog::query()->findOrFail($id);
    }

    public function create(array $data): Blog
    {
        return Blog::query()->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return Blog::query()
            ->where('id', $id)
            ->update($data);
    }

    public function delete(int $id): bool
    {
        return Blog::query()
            ->where('id', $id)
            ->delete();
    }
    
    public function related(int $excludeId, int $limit = 6): Collection
    {
        return Blog::query()
            ->where('id', '!=', $excludeId)
            ->orderByDesc('id')
            ->limit($limit)
            ->get();
    }
}

