<?php

namespace App\Repositories\V1\Blogs;

use App\Models\Blog;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;


interface BlogRepositoryInterface
{
    public function index(int $limit): LengthAwarePaginator;

    public function getById(int $id): Blog;

    public function create(array $data): Blog;

    public function update(int $id, array $data): bool;

    public function delete(int $id): bool;
    
    public function related(int $excludeId, int $limit = 6): Collection;

}

