<?php

namespace App\Repositories\V1\Blogs;

use App\Models\BlogImage;
use Illuminate\Support\Collection;

interface BlogImageRepositoryInterface
{
    public function create(int $blogId, array $images): Collection;

    public function first(int $id): ?BlogImage;

    public function delete(int $id): bool;

    public function getCountByBlogId(int $blogId): int;

    public function assignImages(int $blogId, array $imageIds): bool;
    
    public function deleteByIds(int $blogId, array $imageIds): void;
}
