<?php

namespace App\Providers;

use App\Repositories\V1\Blogs\BlogRepositoryInterface;
use App\Repositories\V1\Blogs\BlogImageRepositoryInterface;
use App\Repositories\V1\Blogs\MysqlBlogRepository;
use App\Repositories\V1\Blogs\MysqlBlogImageRepository;
use App\Repositories\V1\Budgets\BudgetRepositoryInterface;
use App\Repositories\V1\Budgets\MysqlBudgetRepository;
use App\Repositories\V1\BusinessInsights\BusinessInsightRepositoryInterface;
use App\Repositories\V1\BusinessInsights\MysqlBusinessInsightRepository;
use App\Repositories\V1\Categories\CategoryRepositoryInterface;
use App\Repositories\V1\Categories\MysqlCategoryRepository;
use App\Repositories\V1\Cities\CityRepositoryInterface;
use App\Repositories\V1\Cities\MysqlCityRepository;
use App\Repositories\V1\Currencies\CurrencyRepositoryInterface;
use App\Repositories\V1\Currencies\MysqlCurrencyRepository;
use App\Repositories\V1\DesignTypes\DesignTypeRepositoryInterface;
use App\Repositories\V1\DesignTypes\MysqlDesignTypeRepository;
use App\Repositories\V1\Footers\FooterTitleDetailRepositoryInterface;
use App\Repositories\V1\Footers\FooterTitleRepositoryInterface;
use App\Repositories\V1\Footers\MysqlFooterTitleDetailRepository;
use App\Repositories\V1\Footers\MysqlFooterTitleRepository;
use App\Repositories\V1\Home\HomeRepositoryInterface;
use App\Repositories\V1\Home\MysqlHomeRepository;
use App\Repositories\V1\IdeaBooks\IdeaBookRepositoryInterface;
use App\Repositories\V1\IdeaBooks\MysqlIdeaBookRepository;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;
use App\Repositories\V1\InternalUsers\MysqlInternalUserRepository;
use App\Repositories\V1\Contacts\ContactRepositoryInterface;
use App\Repositories\V1\Contacts\MysqlContactRepository;
use App\Repositories\V1\Labels\LabelRepositoryInterface;
use App\Repositories\V1\Labels\MysqlLabelRepository;
use App\Repositories\V1\Offers\MysqlOfferRepository;
use App\Repositories\V1\Offers\OfferRepositoryInterface;
use App\Repositories\V1\PricingUnits\MysqlPricingUnitRepository;
use App\Repositories\V1\PricingUnits\PricingUnitRepositoryInterface;
use App\Repositories\V1\Professionals\MysqlProfessionalRepository;
use App\Repositories\V1\Professionals\ProfessionalRepositoryInterface;
use App\Repositories\V1\Projects\MysqlProjectRepository;
use App\Repositories\V1\Projects\ProjectRepositoryInterface;
use App\Repositories\V1\ProjectTypes\MysqlProjectTypeRepository;
use App\Repositories\V1\ProjectTypes\ProjectTypeRepositoryInterface;
use App\Repositories\V1\Rates\MysqlRateRepository;
use App\Repositories\V1\Rates\RateRepositoryInterface;
use App\Repositories\V1\Roles\MysqlPermissionRepository;
use App\Repositories\V1\Roles\PermissionRepositoryInterface;
use App\Repositories\V1\Services\MysqlServiceRepository;
use App\Repositories\V1\Services\ServiceRepositoryInterface;
use App\Repositories\V1\Settings\MysqlSettingRepository;
use App\Repositories\V1\Settings\SettingRepositoryInterface;
use App\Repositories\V1\Sliders\MysqlSliderRepository;
use App\Repositories\V1\Sliders\SliderRepositoryInterface;
use App\Repositories\V1\States\MysqlStateRepository;
use App\Repositories\V1\States\StateRepositoryInterface;
use App\Repositories\V1\Tags\MysqlTagRepository;
use App\Repositories\V1\Tags\TagRepositoryInterface;
use App\Repositories\V1\Users\MysqlUserRepository;
use App\Repositories\V1\Users\UserRepositoryInterface;
use App\Repositories\V1\Countries\CountryRepositoryInterface;
use App\Repositories\V1\Countries\MysqlCountryRepository;
use App\Repositories\V1\Projects\MysqlProjectImageRepository;
use App\Repositories\V1\Projects\ProjectImageRepositoryInterface;
use App\Repositories\V1\Projects\ProjectLikeRepository;
use App\Repositories\V1\Projects\ProjectLikeRepositoryInterface;
use App\Repositories\V1\SubCategories\SubCategoryRepository;
use App\Repositories\V1\SubCategories\SubCategoryRepositoryInterface;
use Illuminate\Support\ServiceProvider;

class RepositoriesServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        foreach ($this->repositoriesMapping() as $contract => $concrete) {
            $this->app->bind($contract, $concrete);
        }
    }

    private function repositoriesMapping(): array
    {
        return [
            FooterTitleDetailRepositoryInterface::class => MysqlFooterTitleDetailRepository::class,
            InternalUserRepositoryInterface::class => MysqlInternalUserRepository::class,
            FooterTitleRepositoryInterface::class => MysqlFooterTitleRepository::class,
            PricingUnitRepositoryInterface::class => MysqlPricingUnitRepository::class,
            PermissionRepositoryInterface::class => MysqlPermissionRepository::class,
            CurrencyRepositoryInterface::class => MysqlCurrencyRepository::class,
            CategoryRepositoryInterface::class => MysqlCategoryRepository::class,
            SettingRepositoryInterface::class => MysqlSettingRepository::class,
            SliderRepositoryInterface::class => MysqlSliderRepository::class,
            LabelRepositoryInterface::class => MysqlLabelRepository::class,
            StateRepositoryInterface::class => MysqlStateRepository::class,
            CityRepositoryInterface::class => MysqlCityRepository::class,
            UserRepositoryInterface::class => MysqlUserRepository::class,
            HomeRepositoryInterface::class => MysqlHomeRepository::class,
            TagRepositoryInterface::class => MysqlTagRepository::class,
            CountryRepositoryInterface::class => MysqlCountryRepository::class,
            SubCategoryRepositoryInterface::class => SubCategoryRepository::class,
            ProjectRepositoryInterface::class => MysqlProjectRepository::class,
            ProjectImageRepositoryInterface::class => MysqlProjectImageRepository::class,
            BlogRepositoryInterface::class => MysqlBlogRepository::class,
            BlogImageRepositoryInterface::class => MysqlBlogImageRepository::class,
            ContactRepositoryInterface::class => MysqlContactRepository::class,
            ProjectLikeRepositoryInterface::class => ProjectLikeRepository::class,


        ];
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
