<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserDetail extends Model
{
    protected $guarded = [];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }

    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function getImageAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url('professionals/logos/' . $image) : null;
    }

    public function getCompanyImageAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url('professionals/logos/' . $image) : null;
    }

    public function getBusinessNameAttribute(): ?string
    {
        return $this->{'business_name_' . app()->getLocale()};
    }

    public function getBusinessDescriptionAttribute(): ?string
    {
        return $this->{'business_description_' . app()->getLocale()};
    }
}
