<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasApiTokens;

    protected $table = 'users'; // مهم جداً

    protected $fillable = [
        'name_ar', 'name_en', 'email', 'phone', 'password', 'status', 'type'
    ];

    protected $hidden = [
        'password',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'phone_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    // Relations (مثال)
    public function services() { return $this->belongsToMany(Service::class, 'user_services', 'user_id', 'service_id'); }
    public function workingCities() { return $this->belongsToMany(City::class, 'user_working_cities', 'user_id', 'city_id'); }
    public function tags() { return $this->belongsToMany(Tag::class, 'user_tags', 'user_id', 'tag_id'); }
    public function details() { return $this->hasOne(UserDetail::class); }
    
        public function likes()
    {
        return $this->hasMany(ProjectLike::class);
    }

}
