<?php

namespace App\Models\Traits;

use App\Models\Budget;
use App\Models\Category;
use App\Models\City;
use App\Models\DesignType;
use App\Models\ProjectImage;
use App\Models\ProjectType;
use App\Models\State;
use App\Models\User;
use App\Models\ProjectComment;
use App\Models\Tag;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

trait ProjectRelations
{
    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function projectType(): BelongsTo
    {
        return $this->belongsTo(ProjectType::class);
    }

    public function designType(): BelongsTo
    {
        return $this->belongsTo(DesignType::class);
    }

    public function budget(): BelongsTo
    {
        return $this->belongsTo(Budget::class);
    }

    public function firstImage(): HasOne
    {
        return $this->hasOne(ProjectImage::class);
    }

    public function images(): HasMany
    {
        return $this->hasMany(ProjectImage::class);
    }
    
    public function comments(): HasMany
    {
        return $this->hasMany(ProjectComment::class);
    }
    
    public function tags(): BelongsToMany
    {
        return $this->belongsToMany(Tag::class, 'project_tags', 'project_id', 'tag_id');
    }
}
