<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    protected $fillable = ['name_en', 'name_ar', 'status', 'icon'];

    public function getNameAttribute(): string
    {
        return $this->{'name_' . app()->getLocale()};
    }

    public function getIconAttribute(?string $icon = null): ?string
    {
        return $icon ? s3_images_url('tags/icons/' . $icon) : null;
    }

    public function setIconAttribute($value): void
    {
        $this->attributes['icon'] = upload_s3_images($value, 'tags/icons');
    }
}
