<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class State extends Model
{
    protected $guarded = [];

    public function cities(): HasMany
    {
        return $this->hasMany(City::class);
    }

    public function getNameAttribute(): string
    {
        return $this->{'name_' . app()->getLocale()};
    }
     public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
