<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    protected $guarded = [];

    public function getImageEnAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url($image) : null;
    }

    public function getImageArAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url( $image) : null;
    }

    public function setImageEnAttribute($value): void
    {
        $this->attributes['image_en'] = upload_s3_images($value, 'sliders');
    }

    public function setImageArAttribute($value): void
    {
        $this->attributes['image_ar'] = upload_s3_images($value, 'sliders');
    }
}
