<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Service extends Model
{
    protected $fillable = ['name_en', 'name_ar', 'category_id', 'home_status','status', 'description', 'image', 'icon', 'sort'];

    public function getNameAttribute(): string
    {
        $val = $this->{'name_' . app()->getLocale()};
        if (!$val) {
            $val = $this->name_en ?: $this->name_ar ?: '';
        }
        return (string) $val;
    }

    public function getImageAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url($image) : null;
    }

    public function getIconAttribute(?string $image = null): ?string
    {
        return $image ? s3_images_url('services/icons/' . $image) : null;
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function offers(): HasMany
    {
        return $this->hasMany(ServiceOffer::class);
    }
}
