<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\City;
use App\Models\PropertyCategory;

class PropertyRequirement extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_type',
        'price_range',
        'city_id',
        'category_id',
        'full_name',
        'terms_accepted',
        'status',
        'phone',
    'email',
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}
