<?php

namespace App\Http\Resources\V1;

use App\Enums\UserStatusEnum;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'status' => UserStatusEnum::getNameFromValue($this->status),
            'image' => $this->details?->image,
            'created_at' => $this->created_at->format('Y-m-d'),
        ];
    }
}
