<?php

namespace App\Http\Resources\V1;

use App\Enums\SettingsEnum;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
{
    $value = $this->value;

    if ($value) {

        if (filter_var($value, FILTER_VALIDATE_URL)) {
            return [
                'id' => $this->id,
                'name' => $this->name,
                'value' => $value,
            ];
        }

        if (
            str_contains($value, '/')
            || preg_match('/\.(jpg|jpeg|png|webp|svg)$/i', $value)
        ) {

            if (!str_starts_with($value, 'settings/')) {
                $value = 'settings/' . ltrim($value, '/');
            }

            $value = s3_images_url($value);
        }
    }

    return [
        'id' => $this->id,
        'name' => $this->name,
        'value' => $value,
    ];
}

}
