<?php

namespace App\Http\Resources\V1\Projects;

use App\Enums\Project\ProjectStatusEnum;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\V1\LookupResource;
class ProfessionalProjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $authUserId = $request->user() ? $request->user()->id : null;

        return [
            'id' => $this->id,
            'name' => $this->name,
            'area' => $this->area,
            'description' => $this->description,
            'imagesCount' => $this->images_count,
            'mainImage' => $this->firstImage?->image,
            'status' => ProjectStatusEnum::getNameFromValue($this->status),
            'relations' => [
            'is_liked' => $this->likes->contains('user_id', $authUserId) ? 1 : 0,
            'likesCount' => $this->likes->count(),
            'projectType' => LookupResource::make($this->projectType),
            'category'  => LookupResource::make($this->category),
            'country' => LookupResource::make($this->state?->country),
            'state' => LookupResource::make($this->state),
            'city' => LookupResource::make($this->city),
            'images' => ProjectImageResource::collection($this->images),
            ]
        ];
    }
}
