<?php

namespace App\Http\Resources\V1\Projects;

use App\Enums\Project\ProjectStatusEnum;
use App\Http\Resources\V1\LookupResource;
use App\Http\Resources\V1\ProfessionalProfileResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\V1\TagResource; 

class ProfessionalProjectDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $authUser = $request->user();
        return [
            'id' => $this->id,
            'name_en' => $this->name_en,
            'name_ar' => $this->name_ar,
            'area_en' => $this->area_en,
            'area_ar' => $this->area_ar,
            'description_en' => $this->description_en,
            'description_ar' => $this->description_ar,
            'status' => ProjectStatusEnum::getNameFromValue($this->status),
            'relations' => [
                'likesCount' => $this->project_likes_count,     
                'is_liked' => $authUser ? $this->isLikedByUser($authUser) : 0,     
                'images' => ProjectImageResource::collection($this->images),
                'country' => LookupResource::make($this->state?->country),
                'state' => LookupResource::make($this->state),
                'city' => LookupResource::make($this->city),
                'projectType' => LookupResource::make($this->projectType),
                'designType' => LookupResource::make($this->designType),
                'budget' => LookupResource::make($this->budget),
                'category' => LookupResource::make($this->category),
                'tags' => TagResource::collection($this->tags),             
                'user' => ProfessionalProfileResource::make($this->user)
                    ->withReloadRelations(category: true,
                        tags: false,
                        services: false,
                        ideaBooks: false,
                        projects: false,
                        country: false,
                        states: false,
                        cities: false,
                        rates: false,
                        offers: false,
                        profileCovers: false,
                        businessInsights: false),
            ]
        ];
    }
    private function isLikedByUser($user)
    {
        return $user && $this->projectLikes()->where('user_id', $user->id)->exists() ? 1 : 0;
    }
}
