<?php

namespace App\Http\Resources\V1;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FooterTitleDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
           $link = $this->link;

        if ($this->redirect_to == 1 && $link) {
            $baseUrl = 'http://127.0.0.1:8000'; 

            $link = rtrim($baseUrl, '/') . '/' . ltrim($link, '/');
        }

        return [
            'id' => $this->id,
            'titleEn' => $this->title_en,
            'titleAr' => $this->title_ar,
            'footer_title_id' => $this->footer_title_id,
            'status' => $this->status,
            'redirectTo' => $this->redirect_to,
            'link' => $link,
        ];
    }
}
