<?php

namespace App\Http\Resources\V1;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'nameEn' => $this->name_en,
            'nameAr' => $this->name_ar,
            'descriptionEn' => $this->description_en,
            'descriptionAr' => $this->description_ar,
            'status' => $this->status,
            'homeStatus' => $this->home_status,
            'image' => $this->image,
            // 'icon' => $this->icon,
            'footerVisibility' => $this->footer_visibility,
        ];
    }
}
