<?php

namespace App\Http\Resources\V1\Blogs;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BlogResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name_en' => $this->name_en,
            'name_ar' => $this->name_ar,
            'title_en' => $this->title_en,
            'title_ar' => $this->title_ar,
            'description_en' => $this->description_en,
            'description_ar' => $this->description_ar,
            'metaTitle_en' => $this->meta_title_en,
            'metaTitle_ar' => $this->meta_title_ar,
            'metaDescription_en' => $this->meta_description_en,
            'metaDescription_ar' => $this->meta_description_ar,
            'altImage_en' => $this->alt_image_en,
            'altImage_ar' => $this->alt_image_ar,
            'createdAt' => $this->created_at,
            'relations' => [
                'images' => BlogImageResource::collection($this->images),
                'relatedArticles' => BlogResource::collection($this->whenLoaded('relatedArticles')),
            ],
        ];
    }
}

