<?php

namespace App\Http\Requests\V1\Users;

use App\Enums\UserStatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class ChangeStatusUserRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-users');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', new Enum(UserStatusEnum::class)],
        ];
    }
}
