<?php

namespace App\Http\Requests\V1\SubCategories;

use App\Http\Requests\BaseFormRequest;
use Illuminate\Foundation\Http\FormRequest;

class UpdateSubCategoryRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'name_en'        => 'required|string|max:255',
            'name_ar'        => 'required|string|max:255',
            'slug'        => 'required|string|unique:sub_categories,slug,' . $this->route('id'),
            'slug_ar'        => 'required|string|unique:sub_categories,slug,' . $this->route('id'),

            'category_id' => 'required|exists:categories,id',
        ];
    }
}
