<?php

namespace App\Http\Requests\V1\States;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;
use Illuminate\Validation\Rule;

class UpdateStateRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-states');
    }

    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string'],
            'name_ar' => ['required', 'string'],
            'country_id' => ['required', 'integer', Rule::exists('countries', 'id')],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}
