<?php

namespace App\Http\Requests\V1\Sliders;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class ChangeStatusSliderRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-sliders');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}
