<?php

namespace App\Http\Requests\V1\Roles;

use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;

class StoreRoleRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-roles');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', Rule::unique('roles', 'name')],
            'permission_ids' => ['required', 'array', 'min:1'],
            'permission_ids.*' => ['integer'],
        ];
    }
}
