<?php

namespace App\Http\Requests\V1\Projects;

use App\Enums\CategoryTypeEnum;
use App\Enums\Project\ProjectTypeEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Enum;

class StoreBulkProjectRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'projects' => ['required', 'array', 'min:1'],
            'projects.*' => ['required', 'array'],
            'projects.*.name_en' => ['required', 'string'],
            'projects.*.name_ar' => ['required', 'string'],
            'projects.*.description_en' => ['required', 'string'],
            'projects.*.description_ar' => ['required', 'string'],
            'projects.*.area_en' => ['required', 'string'],
            'projects.*.area_ar' => ['required', 'string'],
            'projects.*.type' => ['required', 'numeric', new Enum(ProjectTypeEnum::class)],
            'projects.*.images' => ['required', 'array', 'max:' . config('general.project_image_limit')],
            'projects.*.images.*' => ['integer'],
            'projects.*.project_type_id' => ['required_if:projects.*.type,' . ProjectTypeEnum::PROJECT->value, 'numeric',
                Rule::exists('project_types', 'id')->where('status', StatusEnum::ACTIVE->value)],
            'projects.*.country_id' => ['required_if:projects.*.type,' . ProjectTypeEnum::PROJECT->value, 'integer',
                Rule::exists('countries', 'id')->where('status', StatusEnum::ACTIVE->value)],
            'projects.*.state_id' => ['required_if:projects.*.type,' . ProjectTypeEnum::PROJECT->value, 'numeric',
                Rule::exists('states', 'id')->where('status', StatusEnum::ACTIVE->value)],
            'projects.*.city_id' => ['required_if:projects.*.type,' . ProjectTypeEnum::PROJECT->value, 'numeric',
                Rule::exists('cities', 'id')
                    ->where('status', StatusEnum::ACTIVE->value)],
            'projects.*.budget_id' => ['nullable','numeric',Rule::exists('budgets', 'id')->where('status', StatusEnum::ACTIVE->value)],
            'projects.*.category_id' => ['nullable','numeric',Rule::exists('categories', 'id')->where('status', StatusEnum::ACTIVE->value)->where('type', CategoryTypeEnum::IDEA_BOOK->value)],
        ];
    }
}