<?php

namespace App\Http\Requests\V1\Projects;

use App\Enums\Project\ProjectStatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Validation\Rules\Enum;

class ChangeProjectStatusRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'integer', new Enum(ProjectStatusEnum::class)],
        ];
    }
}
