<?php

namespace App\Http\Requests\V1\InternalUsers;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Enum;

class StoreInternalUserRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-internal-users');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'email' => ['nullable', 'email', Rule::unique('internal_users', 'email')],
            'password' => ['required', 'string', 'min:8'],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
            'role_ids' => ['nullable', 'array'],
            'role_ids.*' => ['integer'],
            'phone_number' => [
                'required',
                'string',
                'regex:/^(?:\+9665|9665|05|5)\d{8}$/',
                'unique:internal_users,phone_number',
            ],

        ];
    }

    public function messages(): array
    {
        return [
            'phone_number.regex' => 'رقم الجوال يجب أن يكون رقم سعودي صالح.'
        ];
    }
}
