<?php

namespace App\Http\Requests\V1\InternalUsers;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class ChangeStatusInternalUserRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-internal-users');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}
